//
//  MCConfigDOServer.h

//  MCClientServer
//
//  Created by Michael Clark on 09-09-17.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//


#import <Foundation/Foundation.h>


@class MCPGServer;

@interface MCConfigDOServer : NSObject {
	id     delegate; // Weak reference
}

- (id)initWithDelegate: (id)aDelegate;

- (BOOL)pingTest; // Connection testing

- (void)closeConnection;

#pragma mark Postgres
- (BOOL)isPostgresRunning;
- (BOOL)startPostgresWithOptions:(NSArray*)options error:(NSError **)error;
- (BOOL)startPostgresAndReturnError: (NSError **)error;
- (BOOL)stopPostgresAndReturnError: (NSError **)error;
- (BOOL)restartPostgresWithOptions:(NSArray *)options error:(NSError **)error;

- (BOOL)isPostgresEnvironmentInitialized;
- (BOOL)initializePostgresEnvironmentAndReturnError:(NSError **)error;

- (BOOL)enableFSyncWritethroughAndReturnError: (NSError**)error;
- (BOOL)disableFSyncWritethroughAndReturnError: (NSError**)error;

#pragma mark Cloud Keychain accessors
- (NSString *)cloudPasswordForUsername:(NSString *)username;
- (BOOL)saveCloudPassword:(NSString *)password forUsername:(NSString *)username;

- (BOOL)deleteClientStageDirectory:(NSString *)directory;

#pragma mark Subclass Methods
- (NSString*)eventTrackerDatabaseFileName;

@end



@interface NSObject (MCConfigDOServerDelegate)

- (void)shutdownDOConnection;

@end
